<?php
class SvcRechercheGenerale
{
	function SvcRechercheGenerale ()
	{
		BDDconnect_utf8();
		
	}
	
	function executeRecherche($requete)
	{
		$retour = array();
		$tab_perimetre = $this->_genere_param_perimetre($requete);
		$tab_loc = $this->_genere_param_loc($requete);
		$prix = $this->_genere_param_prix($requete);
			
		if ($requete['type_recherche'] == 'element_avance') 
		{
			switch ($requete['element'])
			{
				case 'chanson':
					$retour['ELEMENTS_RETOUR'] = array('chanson');
					$retour['chanson'] = $this->_chansons_get_requete_complexe($requete['chaine'], $requete['styles']);
					break;
				case 'artiste':
					$retour['ELEMENTS_RETOUR'] = array('artiste');
					$retour['artiste'] = $this->_artistes_get_requete_complexe($requete['chaine'], $requete['styles'], $tab_loc, $tab_perimetre);
					break;
				case 'concert':
					$retour['ELEMENTS_RETOUR'] = array('concert');
					$retour['concert'] = $this->_concerts_get_requete_complexe($requete['chaine'], $requete['styles'], $prix, $tab_loc, $tab_perimetre);
					break;
				case 'pro':
					$retour['ELEMENTS_RETOUR'] = array('pro');
					$retour['pro'] = $this->_pros_get_requete_complexe($requete['chaine'], $requete['activites'], $tab_loc, $tab_perimetre);
					break;
				case 'actu':
					$retour['ELEMENTS_RETOUR'] = array('article');
					$retour['article']['soun'] = $this->_sounactu_get_requete_complexe($requete['chaine']);
					$retour['article']['user'] = $this->_articles_get_requete_complexe($requete['chaine'] /*, $tab_loc, $tab_perimetre*/);
					break;
			}
		}
		else if ($requete['type_recherche'] == 'generale')
		{
			$retour['ELEMENTS_RETOUR'] = array('chanson', 'artiste', 'concert', 'pro', 'article');
			$retour['chanson'] = $this->_chansons_get_requete_complexe($requete['chaine']);
			$retour['artiste'] = $this->_artistes_get_requete_complexe($requete['chaine']);
			$retour['concert'] = $this->_concerts_get_requete_complexe($requete['chaine']);
			$retour['pro'] = $this->_pros_get_requete_complexe($requete['chaine']);
			$retour['article']['soun'] = $this->_sounactu_get_requete_complexe($requete['chaine']);
			$retour['article']['user'] = $this->_articles_get_requete_complexe($requete['chaine']);
		}
		
		return $retour;
	}
	
	function _genere_param_perimetre($requete)
	{
		$tab_perimetre = array();
		if (is_numeric($requete['perimetre']) && is_int(1+$requete['perimetre']) && $requete['perimetre'] > 0)
		{
			$tab_perimetre['zone'] = $requete['perimetre'];
			$tab_perimetre['lat'] = $requete['latitude'];
			$tab_perimetre['lon'] = $requete['longitude'];
			
			return $tab_perimetre;
		}
		else return array('zone' => 0, 'lat' => 0, 'lon' => 0);
	}
	
	function _genere_param_loc($requete)
	{
		$tab_loc = array();
		
		if (is_numeric($requete['loc']) && is_int(1+$requete['loc']) && strlen($requete['loc']) == 2)
		{
			$tab_loc['type'] = 'num_departement';
			$tab_loc['valeur'] = $requete['loc'];
			return $tab_loc;
		}
		else if (is_numeric($requete['loc']) && is_int(1+$requete['loc']) && strlen($requete['loc']) == 5)
		{
			$tab_loc['type'] = 'code_postal';
			$tab_loc['valeur'] = $requete['loc'];
			return $tab_loc;
		}
		else if (strlen($requete['loc']) > 0)
		{
			$tab_loc['type'] = 'nom_ville';
			$tab_loc['valeur'] = $requete['loc'];
			return $tab_loc;
		}
		else return array('type' => 'aucun');
	}
	
	function _genere_param_prix($requete)
	{
		if (is_numeric($requete['prix_max']) && $requete['prix_max'] >= 0)
		{
			return $tab_perimetre['prix_max'];
		}
		else return -1;
	}
	
	function _artistes_execute_requete ($requete, $perimetre = array('zone' => 0, 'lat' => 0, 'lon' => 0))
	{
		//include_once('modules/geoloc/classes/CGeoloc.class.php');//auto
		$G = new CGeoloc();
			
		$resultat = array();
		if ($r = ifReq($requete))
		{
			$i = 0;
			while ($artiste = mysql_fetch_assoc($r))
			{
				$resultat[$i] = $artiste;
				if ($perimetre['zone'] > 0)
				{
					$distance = $G->GCDistance($perimetre['lat'], $perimetre['lon'], $artiste['latitude'], $artiste['longitude']);
					$resultat[$i]['distance'] = round($distance);
				}
				++$i;
			}
		}
		else echo $requete;
	
		return $resultat;
	}
	
	function _artistes_get_requete_complexe ($chaine = '', $styles = array(), $loc = array('type' => 'aucun'),
											 $perimetre = array('zone' => 0, 'lat' => 0, 'lon' => 0))
	{
		$requete_finale = '';
		if ($chaine != '')
		{
			$mots = $this->_decoupe_chaine($chaine);
			if (count($mots) > 1)
			{
				$r1 = $this->_artistes_get_requete_simple ($this->_genere_where_chaine_ordre('pseudo', $mots), $styles, $loc, $perimetre);
				$r2 = $this->_artistes_get_requete_simple ($this->_genere_where_chaine_and_or('pseudo', $mots, 'AND'), $styles, $loc, $perimetre);
				$r3 = $this->_artistes_get_requete_simple ($this->_genere_where_chaine_and_or('pseudo', $mots, 'OR'), $styles, $loc, $perimetre);
				$requete_finale = "$r1 UNION $r2 UNION $r3";
			}
			else
			{
				$chaine = $mots[0];
				$requete_finale = $this->_artistes_get_requete_simple (" pseudo LIKE '%$chaine%'", $styles, $loc, $perimetre);
			}
		}
		else $requete_finale = $this->_artistes_get_requete_simple ('', $styles, $loc, $perimetre);
		return $this->_artistes_execute_requete ($requete_finale, $perimetre);
	}
	
	/**
	 * @param $chaine (string) : champ de recherche libre utilisé sur le nom d'artiste
	 * @param $styles (array) : liste d'ids de styles
	 * @param $loc (array) : format : ['type'] => (code_postal | nom_ville | num_departement | num_region ) (string)
	 * 								  ['valeur'] => (string)
	 * @param $perimetre (array) : format : ['zone'] => (nombre) km
	 * 									   ['lat'] => (nombre) latitude en degrees decimaux
	 * 									   ['lon'] => (nombre) longitude en degrees decimaux
	 * @return unknown_type
	 */
	function _artistes_get_requete_simple ($chaine = '', $styles = array(), $loc = array('type' => 'aucun'),
										   $perimetre = array('zone' => 0, 'lat' => 0, 'lon' => 0))
	{
		$where_chaine = '';
		$where_villes = '';
		$where_styles = '';
		$from_styles = '';
		
		//Geolocalisation
		if ($perimetre['zone'] > 0)
		{
			//include_once('modules/geoloc/classes/CGeoloc.class.php');//auto
			
			$G = new CGeoloc();
			$dg = $G->GetAmplitudeDG($perimetre['lat'], $perimetre['lon'], $perimetre['zone']);
			
			$where_villes = " AND latitude BETWEEN $dg[lat_min] AND $dg[lat_max]
			AND longitude BETWEEN $dg[lon_min] AND $dg[lon_max]";
		}
		else if ($loc['type'] != 'aucun') $where_villes = $this->_genere_where_villes($loc);
		
		//Styles musicaux
		$nb_styles = count($styles);
		if ($nb_styles > 0)
		{
			$from_styles = ', soun__styles_musicaux_membre';
			$ids = implode(',', $styles);
			
			$where_styles = " AND soun__styles_musicaux_membre.id_utilisateur = usr__utilisateurs.id_auto
			AND id_style IN ($ids)";
		}
		
		//Champ de recherche libre sur le nom
		if ($chaine != '') $where_chaine =  "AND $chaine";
		
		$requete = "SELECT id_auto as id_utilisateur, pseudo, avatar, geoloc__ville.latitude, geoloc__ville.longitude
		FROM usr__utilisateurs, geoloc__ville $from_styles
		WHERE groupe = 'artiste'
		AND actif = 1
		AND id_ville = id
		$where_styles
		$where_villes
		$where_chaine";
		
		return $requete;
	}

	function _pros_execute_requete ($requete, $perimetre = array('zone' => 0, 'lat' => 0, 'lon' => 0))
	{
		//include_once('modules/geoloc/classes/CGeoloc.class.php');//auto
		$G = new CGeoloc();
			
		$resultat = array();
		if ($r = ifReq($requete))
		{
			$i = 0;
			while ($pro = mysql_fetch_assoc($r))
			{
				$resultat[$i] = $pro;
				if ($perimetre['zone'] > 0)
				{
					$distance = $G->GCDistance($perimetre['lat'], $perimetre['lon'], $pro['latitude'], $pro['longitude']);
					$resultat[$i]['distance'] = round($distance);
				}
				++$i;
			}
		}
		else echo $requete;
	
		return $resultat;
	}
	
	function _pros_get_requete_complexe ($chaine = '', $activites = array(), $loc = array('type' => 'aucun'),
											 $perimetre = array('zone' => 0, 'lat' => 0, 'lon' => 0))
	{
		$requete_finale = '';
		if ($chaine != '')
		{
			$mots = $this->_decoupe_chaine($chaine);
			if (count($mots) > 1)
			{
				$r1 = $this->_pros_get_requete_simple ($this->_genere_where_chaine_ordre('pseudo', $mots), $activites, $loc, $perimetre);
				$r2 = $this->_pros_get_requete_simple ($this->_genere_where_chaine_and_or('pseudo', $mots, 'AND'), $activites, $loc, $perimetre);
				$r3 = $this->_pros_get_requete_simple ($this->_genere_where_chaine_and_or('pseudo', $mots, 'OR'), $activites, $loc, $perimetre);
				$requete_finale = "$r1 UNION $r2 UNION $r3";
			}
			else
			{
				$chaine = $mots[0];
				$requete_finale = $this->_pros_get_requete_simple (" pseudo LIKE '%$chaine%'", $activites, $loc, $perimetre);
			}
		}
		else $requete_finale = $this->_pros_get_requete_simple ('', $activites, $loc, $perimetre);
		
		return $this->_pros_execute_requete ($requete_finale, $perimetre);
	}
	
	/**
	 * @param $chaine (string) : champ de recherche libre utilisé sur le nom du pro
	 * @param $activites (array) : liste d'ids d'activites
	 * @param $loc (array) : format : ['type'] => (code_postal | nom_ville | num_departement | num_region ) (string)
	 * 								  ['valeur'] => (string)
	 * @param $perimetre (array) : format : ['zone'] => (nombre) km
	 * 									   ['lat'] => (nombre) latitude en degrees decimaux
	 * 									   ['lon'] => (nombre) longitude en degrees decimaux
	 * @return unknown_type
	 */
	function _pros_get_requete_simple ($chaine = '', $activites = array(), $loc = array('type' => 'aucun'),
									   $perimetre = array('zone' => 0, 'lat' => 0, 'lon' => 0))
	{
		$where_chaine = '';
		$where_villes = '';
		$where_activites = '';
		$from_activites = '';
		
		//Geolocalisation
		if ($perimetre['zone'] > 0)
		{
			//include_once('modules/geoloc/classes/CGeoloc.class.php');//auto
			
			$G = new CGeoloc();
			$dg = $G->GetAmplitudeDG($perimetre['lat'], $perimetre['lon'], $perimetre['zone']);
			
			$where_villes = " AND latitude BETWEEN $dg[lat_min] AND $dg[lat_max]
			AND longitude BETWEEN $dg[lon_min] AND $dg[lon_max]";
		}
		else if ($loc['type'] != 'aucun') $where_villes = $this->_genere_where_villes($loc);
		
		
		//Activites professionnelles
		$nb_activites = count($activites);
		if ($nb_activites > 0)
		{
			$from_activites = ', soun__styles_musicaux_membre';
			$ids = implode(',', $activites);
			
			$where_activites = " AND soun__activites_pros_membre.id_utilisateur = usr__utilisateurs.id_auto
			AND id_activite IN ($ids)";
		}
		
		
		//Champ de recherche libre sur le nom
		if ($chaine != '') $where_chaine =  "AND $chaine";
		
		$requete = "SELECT id_auto as id_utilisateur, pseudo, avatar, geoloc__ville.latitude, geoloc__ville.longitude
		FROM usr__utilisateurs, geoloc__ville $from_styles
		WHERE groupe = 'pro'
		AND actif = 1
		AND id_ville = id
		$where_styles
		$where_villes
		$where_chaine";
		
		return $requete;
	}
	
	function _concerts_execute_requete($requete, $perimetre = array('zone' => 0, 'lat' => 0, 'lon' => 0))
	{
		//include_once('modules/geoloc/classes/CGeoloc.class.php');//auto
		$G = new CGeoloc();
		
		$resultat = array();

		if ($r = ifReq($requete))
		{
			$i = 0;
			while ($concert = mysql_fetch_assoc($r))
			{
				$resultat[$i] = $concert;
				if ($perimetre['zone'] > 0)
				{
					$distance = $G->GCDistance($perimetre['lat'], $perimetre['lon'], $concert['latitude'], $concert['longitude']);
					$resultat[$i]['distance'] = round($distance);
				}
				
				$req_grps = "SELECT DISTINCT IFNULL( soun__groupes_concert.nom_artiste, usr__utilisateurs.pseudo )
							FROM soun__groupes_concert
							LEFT JOIN usr__utilisateurs ON soun__groupes_concert.id_artiste = usr__utilisateurs.id_auto
							WHERE id_concert = $concert[id_concert]";
				
				$tab_grps = array();
				if ($r2 = ifReq($req_grps))
				{
					while ($grps = mysql_fetch_row($r2)) $tab_grps[] = $grps[0];
					$liste_grps = implode(', ', $tab_grps);
					$resultat[$i]['groupes'] = $liste_grps;
				}
				
				++$i;
			}
		}
		else echo $requete;

		return $resultat;
	}
	
	function _concerts_get_requete_complexe($chaine = '', $styles = array(), $prix = -1, $loc = array('type' => 'aucun'),
										   $perimetre = array('zone' => 0, 'lat' => 0, 'lon' => 0), $autorise_concerts_passes = false)
	{
		$requete_finale = '';
		if ($chaine != '')
		{
			$wheres = array();
			$mots = $this->_decoupe_chaine($chaine);
			if (count($mots) > 1)
			{
				$chaine = $this->_genere_where_chaine_ordre('soun__concert.nom', $mots);	
				$wheres['groupes_concert'] = $this->_genere_where_chaine_ordre('IFNULL( soun__groupes_concert.nom_artiste, usr__utilisateurs.pseudo )', $mots);
				$wheres['orgas_concert'] = $this->_genere_where_chaine_ordre('IFNULL( soun__organisateurs_concert.nom_pro, usr__utilisateurs.pseudo )', $mots);
				$wheres['salles_concert'] = $this->_genere_where_chaine_ordre('IFNULL( soun__concert.nom_salle, usr__utilisateurs.pseudo )', $mots);
				$r1 = $this->_concerts_get_requete_simple ($chaine, $styles, $prix, $loc, $perimetre, $autorise_concerts_passes, $wheres);
				
				$chaine = $this->_genere_where_chaine_and_or('soun__concert.nom', $mots, 'AND');
				$wheres['groupes_concert'] = $this->_genere_where_chaine_and_or('IFNULL( soun__groupes_concert.nom_artiste, usr__utilisateurs.pseudo )', $mots, 'AND');
				$wheres['orgas_concert'] = $this->_genere_where_chaine_and_or('IFNULL( soun__organisateurs_concert.nom_pro, usr__utilisateurs.pseudo )', $mots, 'AND');
				$wheres['salles_concert'] = $this->_genere_where_chaine_and_or('IFNULL( soun__concert.nom_salle, usr__utilisateurs.pseudo )', $mots, 'AND');
				$r2 = $this->_concerts_get_requete_simple ($chaine, $styles, $prix, $loc, $perimetre, $autorise_concerts_passes, $wheres);
				
				$chaine = $this->_genere_where_chaine_and_or('soun__concert.nom', $mots, 'OR');
				$wheres['groupes_concert'] = $this->_genere_where_chaine_and_or('IFNULL( soun__groupes_concert.nom_artiste, usr__utilisateurs.pseudo )', $mots, 'OR');
				$wheres['orgas_concert'] = $this->_genere_where_chaine_and_or('IFNULL( soun__organisateurs_concert.nom_pro, usr__utilisateurs.pseudo )', $mots, 'OR');
				$wheres['salles_concert'] = $this->_genere_where_chaine_and_or('IFNULL( soun__concert.nom_salle, usr__utilisateurs.pseudo )', $mots, 'OR');
				$r3 = $this->_concerts_get_requete_simple ($chaine, $styles, $prix, $loc, $perimetre, $autorise_concerts_passes, $wheres);
				
				$requete_finale = "$r1 UNION $r2 UNION $r3";
			}
			else
			{
				$chaine = $mots[0];
				$wheres['groupes_concert'] = "IFNULL( soun__groupes_concert.nom_artiste, usr__utilisateurs.pseudo ) LIKE '%$chaine%'";
				$wheres['orgas_concert'] = "IFNULL( soun__organisateurs_concert.nom_pro, usr__utilisateurs.pseudo ) LIKE '%$chaine%'";
				$wheres['salles_concert'] = "IFNULL( soun__concert.nom_salle, usr__utilisateurs.pseudo ) LIKE '%$chaine%'";
				$requete_finale = $this->_concerts_get_requete_simple (" soun__concert.nom LIKE '%$chaine%'", $styles, $prix, $loc, $perimetre, $wheres);
			}
		}
		else $requete_finale = $this->_concerts_get_requete_simple ('', $styles, $prix, $loc, $perimetre, $autorise_concerts_passes);
		
		return $this->_concerts_execute_requete ($requete_finale, $perimetre);
	}
	
	/**
	 * @param $chaine (string) : champ de recherche libre utilisé sur le nom du concert, les groupes du concert, les orgas du concert
	 * @param $styles (array) : liste d'ids de styles des groupes d'un concert
	 * @param $prix (int) : prix max du concert, -1 pour pas de critere
	 * @param $loc (array) : format : ['type'] => (code_postal | nom_ville | num_departement | num_region ) (string)
	 * 								  ['valeur'] => (string)
	 * @param $perimetre (array) : format : ['zone'] => (nombre) km
	 * 									   ['lat'] => (nombre) latitude en degrees decimaux
	 * 									   ['lon'] => (nombre) longitude en degrees decimaux
	 * @return unknown_type
	 */
	function _concerts_get_requete_simple ($chaine = '',
											$styles = array(),
											$prix = -1,
											$loc = array('type' => 'aucun'),
											$perimetre = array('zone' => 0, 'lat' => 0, 'lon' => 0),
											$autorise_concerts_passes = false,
											$wheres_chaine = array())
	{
		ifNULL($prix,-1);
		$where_chaine = '';
		
		$where_prix = '';
		$where_villes = '';
		
		$where_styles = '';
		$from_styles = '';
		
		$where_concerts_passes = '';
		
		//Geolocalisation
		if ($perimetre['zone'] > 0)
		{
			//include_once('modules/geoloc/classes/CGeoloc.class.php');//auto
			
			$G = new CGeoloc();
			$dg = $G->GetAmplitudeDG($perimetre['lat'], $perimetre['lon'], $perimetre['zone']);
			
			$where_villes = " AND geoloc__ville.latitude BETWEEN $dg[lat_min] AND $dg[lat_max]
			AND geoloc__ville.longitude BETWEEN $dg[lon_min] AND $dg[lon_max]";
		}
		else if ($loc['type'] != 'aucun') $where_villes = $this->_genere_where_villes($loc);
		
		
		//Styles musicaux
		$nb_styles = count($styles);
		if ($nb_styles > 0)
		{
			$from_styles = ', soun__styles_musicaux_concert';
			$ids = implode(',', $styles);
			
			$where_styles = " AND soun__styles_musicaux_concert.id_concert = soun__concert.id_auto
			AND id_style_musical IN ($ids)";
		}
		
		//Tarif
		if($prix != -1) $where_prix = " AND tarif <= $prix ";
		
		//Concerts passés dans les résultats
		if (!$autorise_concerts_passes) $where_concerts_passes = " AND date_concert >= NOW() ";
		
		//Champ de recherche libre qui porte sur le nom, les groupes, les organisateurs
		if ($chaine != '')
		{
			//Le nom du concert
			$where_chaine =  " AND ( $chaine";
			
			$tab_ids = array();
			
			//Les groupes du concert
			$req_groupes = "SELECT DISTINCT soun__concert.id_auto
							FROM soun__concert
							LEFT JOIN soun__groupes_concert ON soun__concert.id_auto = soun__groupes_concert.id_concert
							LEFT JOIN usr__utilisateurs ON usr__utilisateurs.id_auto = soun__groupes_concert.id_artiste
							WHERE $wheres_chaine[groupes_concert]";
			
			if ($r2 = ifReq($req_groupes))
			{
				while ($grpes = mysql_fetch_row($r2)) $tab_ids[] = $grpes[0];
			}
			
			//Les organisateurs du concert
			$req_orgas = "SELECT DISTINCT soun__concert.id_auto
						FROM soun__concert
						LEFT JOIN soun__organisateurs_concert ON soun__concert.id_auto = soun__organisateurs_concert.id_concert
						LEFT JOIN usr__utilisateurs ON usr__utilisateurs.id_auto = soun__organisateurs_concert.id_pro
						WHERE $wheres_chaine[orgas_concert]";
			
			if ($r2 = ifReq($req_orgas))
			{
				while ($orgas = mysql_fetch_row($r2)) $tab_ids[] = $orgas[0];
			}
			
			//La salle du concert
			$req_salle = "SELECT DISTINCT soun__concert.id_auto
						FROM soun__concert
						LEFT JOIN usr__utilisateurs ON usr__utilisateurs.id_auto = soun__concert.id_salle
						WHERE $wheres_chaine[salles_concert]";
			
			if ($r2 = ifReq($req_salle))
			{
				while ($salle = mysql_fetch_row($r2)) $tab_ids[] = $salle[0];
			}
			//Ajout de tous ces ids
			$nb_ids = count($tab_ids);
			if ($nb_ids > 0)
			{
				$ids = implode(',', $tab_ids);
				$where_chaine .= " OR (soun__concert.id_auto IN ($ids))";
			}
			
			$where_chaine .= ')';
		}
		
		$requete = "SELECT DISTINCT soun__concert.id_auto AS id_concert, soun__concert.nom,
		url_affiche, tarif, geoloc__ville.latitude, geoloc__ville.longitude,
		date_concert, geoloc__ville.nom AS nom_ville, departement
		FROM soun__concert, geoloc__ville $from_styles
		WHERE id_ville = id
		$where_prix 
		$where_styles 
		$where_villes 
		$where_chaine";
		
		return $requete;
	}
	
	function _articles_execute_requete ($requete, $perimetre = array('zone' => 0, 'lat' => 0, 'lon' => 0))
	{
		$resultat = array();
		if ($r = ifReq($requete))
		{
			$i = 0;
			while ($pro = mysql_fetch_assoc($r))
			{
				$resultat[$i] = $pro;
				if ($perimetre['zone'] > 0)
				{
					$distance = $G->GCDistance($perimetre['lat'], $perimetre['lon'], $pro['latitude'], $pro['longitude']);
					$resultat[$i]['distance'] = round($distance);
				}
				++$i;
			}
		}
		else echo $requete;
	
		return $resultat;
	}
	
	
	
	function _articles_get_requete_complexe($chaine = '', $loc = array('type' => 'aucun'), $perimetre = array('zone' => 0, 'lat' => 0, 'lon' => 0))
	{
		$requete_finale = '';
		if ($chaine != '')
		{
			$wheres = array();
			$mots = $this->_decoupe_chaine($chaine);
			if (count($mots) > 1)
			{
				$chaine = $this->_genere_where_chaine_ordre('soun__article.titre', $mots);
				$wheres['texte_articles'] = $this->_genere_where_chaine_ordre('soun__article.texte', $mots);
				$wheres['membre_sujet_articles'] = $this->_genere_where_chaine_ordre('usr__utilisateurs.pseudo', $mots);
				$r1 = $this->_articles_get_requete_simple ($chaine, $loc, $perimetre, $wheres);
				
				$chaine = $this->_genere_where_chaine_ordre('soun__article.titre', $mots);
				$wheres['texte_articles'] = $this->_genere_where_chaine_and_or('soun__article.texte', $mots, 'AND');
				$wheres['membre_sujet_articles'] = $this->_genere_where_chaine_and_or('usr__utilisateurs.pseudo', $mots, 'AND');
				$r2 = $this->_articles_get_requete_simple ($chaine, $loc, $perimetre, $wheres);
				
				$chaine = $this->_genere_where_chaine_ordre('soun__article.titre', $mots);
				$wheres['texte_articles'] = $this->_genere_where_chaine_and_or('soun__article.texte', $mots, 'OR');
				$wheres['membre_sujet_articles'] = $this->_genere_where_chaine_and_or('usr__utilisateurs.pseudo', $mots, 'OR');
				$r3 = $this->_articles_get_requete_simple ($chaine, $loc, $perimetre, $wheres);
				
				$requete_finale = "$r1 UNION $r2 UNION $r3";
			}
			else
			{
				$chaine = $mots[0];
				$wheres['texte_articles'] = "soun__article.texte LIKE '%$chaine%'";
				$wheres['membre_sujet_articles'] = "usr__utilisateurs.pseudo LIKE '%$chaine%'";
				$requete_finale = $this->_articles_get_requete_simple (" soun__article.titre LIKE '%$chaine%'", $loc, $perimetre, $wheres);
			}
		}
		else $requete_finale = $this->_articles_get_requete_simple ('', $styles, $prix, $loc, $perimetre);
		return $this->_articles_execute_requete ($requete_finale, $perimetre);
	}
	
	/**
	 * @param $chaine (string) : champ de recherche libre utilisé sur le titre de l'article, ou son contenu, ou le nom du membre concerné
	 * @param $perimetre (array) : format : ['zone'] => (nombre) km
	 * 									   ['lat'] => (nombre) latitude en degrees decimaux
	 * 									   ['lon'] => (nombre) longitude en degrees decimaux
	 * @return unknown_type
	 */
	function _articles_get_requete_simple ($chaine = '', $loc = array('type' => 'aucun'),
											$perimetre = array('zone' => 0, 'lat' => 0, 'lon' => 0), $wheres_chaine = array())
	{
		$where_chaine = '';
		$where_villes = '';
		$where_styles = '';
		$from_styles = '';
		
		//Geolocalisation
		if ($perimetre['zone'] > 0)
		{
			//include_once('modules/geoloc/classes/CGeoloc.class.php');//auto
			
			$G = new CGeoloc();
			$dg = $G->GetAmplitudeDG($perimetre['lat'], $perimetre['lon'], $perimetre['zone']);
			
			$where_villes = " AND latitude BETWEEN $dg[lat_min] AND $dg[lat_max]
			AND longitude BETWEEN $dg[lon_min] AND $dg[lon_max]";
		}
		else if ($loc['type'] != 'aucun') $where_villes = $this->_genere_where_villes($loc);
		
		//Champ de recherche libre sur le titre article, son texte, le nom de celui a qui il est destiné
		if ($chaine != '')
		{
			//Le nom du concert
			$where_chaine =  " AND ( $chaine OR $wheres_chaine[texte_articles] ";
			
			$tab_ids = array();
			
			//Les membres concernés par l'article
			$req_membre = "SELECT DISTINCT soun__article.id_auto
							FROM soun__article
							LEFT JOIN usr__utilisateurs ON soun__article.id_utilisateur = usr__utilisateurs.id_auto
							WHERE $wheres_chaine[membre_sujet_articles]";
			
			if ($r2 = ifReq($req_membre))
			{
				while ($mbres = mysql_fetch_row($r2)) $tab_ids[] = $mbres[0];
			}
			
			//Ajout de tous ces ids
			$nb_ids = count($tab_ids);
			if ($nb_ids > 0)
			{
				$ids = implode(',', $tab_ids);
				$where_chaine .= " OR (soun__article.id_auto IN ($ids))";
			}
			
			$where_chaine .= ')';
		}
		
		$requete = "SELECT soun__article.id_auto as id_article, titre, date_article, texte,
		pseudo, avatar, geoloc__ville.latitude, geoloc__ville.longitude
		FROM soun__article, usr__utilisateurs, geoloc__ville $from_styles
		WHERE usr__utilisateurs.actif = 1
		AND soun__article.actif = 1
		AND id_ville = id
		AND usr__utilisateurs.id_auto = soun__article.id_utilisateur
		$where_villes 
		$where_chaine";
		
		return $requete;
	}
	
	function _sounactu_execute_requete ($requete)
	{
		$resultat = array();
		if ($r = ifReq($requete))
		{
			$i = 0;
			while ($actu = mysql_fetch_assoc($r))
			{
				$resultat[$i] = $actu;
				++$i;
			}
		}
		else echo $requete;
	
		return $resultat;
	}
	
	
	
	function _sounactu_get_requete_complexe($chaine = '')
	{
		$requete_finale = '';
		if ($chaine != '')
		{
			$wheres = array();
			$mots = $this->_decoupe_chaine($chaine);
			if (count($mots) > 1)
			{
				$chaine = $this->_genere_where_chaine_ordre('soun__actualite.titre', $mots);
				$wheres['texte_actus'] = $this->_genere_where_chaine_ordre('soun__actualite.texte', $mots);
				$r1 = $this->_sounactu_get_requete_simple ($chaine, $wheres);
				
				$chaine = $this->_genere_where_chaine_and_or('soun__actualite.titre', $mots, 'AND');
				$wheres['texte_actus'] = $this->_genere_where_chaine_and_or('soun__actualite.texte', $mots, 'AND');
				$r2 = $this->_sounactu_get_requete_simple ($chaine, $wheres);
				
				$chaine = $this->_genere_where_chaine_ordre('soun__actualite.titre', $mots, 'OR');
				$wheres['texte_actus'] = $this->_genere_where_chaine_and_or('soun__actualite.texte', $mots, 'OR');
				$r3 = $this->_sounactu_get_requete_simple ($chaine, $wheres);
				
				$requete_finale = "$r1 UNION $r2 UNION $r3";
			}
			else
			{
				$chaine = $mots[0];
				$wheres['texte_actus'] = "soun__actualite.texte LIKE '%$chaine%'";
				$requete_finale = $this->_sounactu_get_requete_simple (" soun__actualite.titre LIKE '%$chaine%'", $wheres);
			}
		}
		else $requete_finale = $this->_sounactu_get_requete_simple ('');
		return $this->_sounactu_execute_requete ($requete_finale);
	}
	
	/**
	 * @param $chaine (string) : champ de recherche libre utilisé sur le titre de l'article, ou son contenu, ou le nom du membre concerné
	 * @param $perimetre (array) : format : ['zone'] => (nombre) km
	 * 									   ['lat'] => (nombre) latitude en degrees decimaux
	 * 									   ['lon'] => (nombre) longitude en degrees decimaux
	 * @return unknown_type
	 */
	function _sounactu_get_requete_simple ($chaine = '', $wheres_chaine = array())
	{
		$where_chaine = '';
		
		//Champ de recherche libre sur le titre actualité ou son texte
		if ($chaine != '') $where_chaine =  " AND ( $chaine OR $wheres_chaine[texte_actus] )";
		
		
		//rajouter where visible = 1 (dans la base) a la palce du 1 = 1
		$requete = "SELECT soun__actualite.id_auto as id_actualite, titre, date_publication, texte
		FROM soun__actualite
		WHERE visible = 1
		$where_chaine";
		
		return $requete;
	}
	
	
	function _chansons_execute_requete ($requete)
	{
		$resultat = array();
		if ($r = ifReq($requete))
		{
			$i = 0;
			while ($pro = mysql_fetch_assoc($r))
			{
				$resultat[$i] = $pro;
				++$i;
			}
		}
		else echo $requete;
		
		return $resultat;
	}
	
	
	
	function _chansons_get_requete_complexe($chaine = '', $styles = array())
	{
		$requete_finale = '';
		if ($chaine != '')
		{
			$wheres = array();
			$mots = $this->_decoupe_chaine($chaine);
			if (count($mots) > 1)
			{
				$chaine = $this->_genere_where_chaine_ordre('soun__chanson.titre', $mots);
				$wheres['titre_albums'] = $this->_genere_where_chaine_ordre('soun__album.titre', $mots);
				$r1 = $this->_chansons_get_requete_simple ($chaine, $styles, $wheres);
				
				$chaine = $this->_genere_where_chaine_and_or('soun__chanson.titre', $mots, 'AND');
				$wheres['titre_albums'] = $this->_genere_where_chaine_and_or('soun__album.titre', $mots, 'AND');
				$r2 = $this->_chansons_get_requete_simple ($chaine, $styles, $wheres);
				
				$chaine = $this->_genere_where_chaine_and_or('soun__chanson.titre', $mots, 'OR');
				$wheres['titre_albums'] = $this->_genere_where_chaine_and_or('soun__album.titre', $mots, 'OR');
				$r3 = $this->_chansons_get_requete_simple ($chaine, $styles, $wheres);
				
				$requete_finale = "$r1 UNION $r2 UNION $r3";
			}
			else
			{
				$chaine = $mots[0];
				$wheres['titre_albums'] = "soun__album.titre LIKE '%$chaine%'";
				$requete_finale = $this->_chansons_get_requete_simple (" soun__chanson.titre LIKE '%$chaine%'", $styles, $wheres);
			}
		}
		else $requete_finale = $this->_chansons_get_requete_simple ('', $styles);
		return $this->_chansons_execute_requete ($requete_finale);
	}
	
	/**
	 * @param $chaine (string) : champ de recherche libre utilisé sur le nom du concert, les groupes du concert, les orgas du concert
	 * @param $styles (array) : liste d'ids de styles des groupes d'un concert
	 * 
	 * @return unknown_type
	 */
	function _chansons_get_requete_simple ($chaine = '', $styles = array(), $wheres_chaine = array())
	{
		$where_chaine = '';
		$where_villes = '';
		
		$nb_styles = count($styles);
		if ($nb_styles > 0)
		{
			$from_styles = ', soun__styles_musicaux_membre';
			$ids = implode(',', $styles);
			
			$where_styles = " AND soun__styles_musicaux_membre.id_utilisateur = usr__utilisateurs.id_auto
			AND id_style IN ($ids) ";
		}
		
		//Champ de recherche libre sur le titre article, son texte, le nom de celui a qui il est destiné
		if ($chaine != '')
		{
			//Le nom du concert
			$where_chaine =  " AND ( $chaine  ";
			
			$tab_ids = array();
			
			//Les titres d'albums
			$req_titres = "SELECT DISTINCT soun__chanson.id_auto
							FROM soun__chanson
							LEFT JOIN soun__album ON soun__chanson.id_album = soun__album.id_auto
							WHERE $wheres_chaine[titre_albums]";
			
			if ($r2 = ifReq($req_titres))
			{
				while ($titres = mysql_fetch_row($r2)) $tab_ids[] = $titres[0];
			}
			
			//Ajout de tous ces ids
			$nb_ids = count($tab_ids);
			if ($nb_ids > 0)
			{
				$ids = implode(',', $tab_ids);
				$where_chaine .= " OR (soun__chanson.id_auto IN ($ids))";
			}
			
			$where_chaine .= ')';
		}
		
		$requete = "SELECT DISTINCT soun__chanson.id_auto as id_chanson, soun__chanson.titre, soun__album.titre AS titre_album,
		duree, pseudo, usr__utilisateurs.id_auto as id_utilisateur 
		FROM soun__chanson, usr__utilisateurs, soun__album $from_styles
		WHERE usr__utilisateurs.actif = 1
		AND soun__chanson.visible = 1
		AND usr__utilisateurs.id_auto = soun__chanson.id_artiste
		AND soun__chanson.id_album = soun__album.id_auto
		$where_styles
		$where_villes 
		$where_chaine";
		
		return $requete;
	}
	
	
	function _genere_where_villes($loc)
	{
		$where_villes = '';
		switch($loc['type'])
		{
			case 'code_postal':
				//$where_villes = " AND geoloc__ville.code_postal = '$loc[valeur]'";
				$where_villes = " AND geoloc__ville.insee = (SELECT DISTINCT insee FROM geoloc__ville WHERE code_postal = '$loc[valeur]')";
				break;
			case 'nom_ville':
				$where_villes = " AND geoloc__ville.nom LIKE '$loc[valeur]'";
				break;
			case 'num_departement':
				$where_villes = " AND geoloc__ville.departement = '$loc[valeur]'";
				break;	
			case 'num_region':
				$where_villes = " AND geoloc__ville.departement IN (SELECT departement 
				FROM geoloc__departement
				WHERE num_region = '$loc[valeur]')";
				break;
			case 'code_insee':
				$where_villes = " AND geoloc__ville.insee = '$loc[valeur]'";
				break;
		}
		return $where_villes;
	}
	
	function _decoupe_chaine($chaine)
	{
		$nb_mots_max = 4;
		
		$a_virer = array('%');
		$chaine = str_replace($a_virer, "", $chaine);
		
		$tab_mots_tmp = explode(' ', $chaine);
		$tab_mots = array();
		
		$lng = count($tab_mots_tmp);
		
		for ($i = 0; $i < $lng; $i++)
		{
			$mot = trim($tab_mots_tmp[$i]);
			if(strlen($mot) > 2)
			{
				$tab_mots[] = $mot;
				if (count($tab_mots) == $nb_mots_max) break;
			}
		}
		return $tab_mots;
	}
	
	function _genere_where_chaine_ordre($attribut, $tab_mots)
	{
		$like = implode('%', $tab_mots);
		$where = " ( $attribut LIKE '%$like%' ) ";
		return $where;
	}
	
	function _genere_where_chaine_and_or($attribut, $tab_mots, $mode)
	{
		$like = '';
		$lng = count($tab_mots);
		$where = " ( $attribut LIKE '%$tab_mots[0]%' ) ";
		for ($i = 1; $i < $lng; $i++) $where .= " $mode ( $attribut LIKE '%$tab_mots[$i]%' ) ";
		$where = " ( $where ) ";
		return $where;
	}
}

?>