<?php

class RelanceForm{
	
	protected $formulaire;
	
	public function __construct($obj = null){
		
		$form = new TForm('Relances');
		$form->setClassCSS('form_edit');
		
		if(!is_null($obj)){
			$form->add('Hidden')->name('edit')->value('edit');
			$form->add('Hidden')->name('id');
		}
		else{
			$form->add('Hidden')->name('new')->value('new');
		}
		
		$form->add('Text')->label('Titre')->name('titre')->readonly();
		$form->add('Text')->label('Total HT')->name('total')->value(round($obj->total,2))->readonly();
		
//		$form->add('Text')->label('TVA')->name('tva');
		
//		$total_tva = $obj->total * ($obj->tva / 100); 
//		$total = $obj->total + $total_tva; 
		$obj->getTotaux();
		$form->add('Text')->label('Taux TVA')->name('tva')->value($obj->tva);
		$form->add('Text')->label('Total TVA')->name('total_tva')->value($obj->total_tva)->readonly();
		$form->add('Text')->label('Total TTC')->name('total_ttc')->value($obj->total_ttc)->readonly();

		$form->add('Select')
			->label('Paiment pour')
			->name('duree_valid')
			->options(array("1"=>"1 an","2"=>"2 ans","3"=>"3 ans","4"=>"4 ans"));
		
		
		$form->add('Separateur')->label('<br/><h4>Les hébergements et services associés</h4>')->name('plop')->required(false);
		
		foreach($obj->getHebergements() as $h){
			
			$form->add('Checkbox')
			 ->label($h->designation)
			 ->id('hebergement_'.$h->id)
			 ->value($h->id)
			 ->name('hebergements[]')
			 ->defaultChoice(true)
			 ->required(false);
		}

		
		$form->add('Separateur')->label('<br/><h4>Ajouter un hébergement ou service</h4>')->name('plop')->required(false);;
		$h = new Hebergements();
		$select = $h->findAllForFormValid('id','designation', $obj->id_client, $obj->getHebergements());
		$form->add('Select')->label('')->name('add_hebergement')->options($select)->required(false);
		
//		$form->add('Separateur')->label(link_to('Lui ajouter un service ou un hébergement','relances','addHebergement',array('id_relance' => $obj->id)))->name('lien_add');
		
		$form->add('Separateur')->label('<input type="submit" name="ajouter" value="Ajouter service" />')->name('plop')->required(false);
		
		$this->formulaire = $form;
	}
	
	public function getForm(){
		return $this->formulaire;
	}
	
	 
	
	
}


?>