<?php
class Rech_filtre_spec {

	private $filtres=array();
	private $order=array();
	private $types_specs_autorisees=array();
	//	private $parsed = false;

	private $indexeur;

	public function Rech_filtre_spec() {
		$this->indexeur = new Rech_Indexeur();
	}

	/**
	 * @param $nom_spec "id_TA"
	 * @param $val_spec String ou array
	 * @return unknown_type
	 */
	public function add_filtre($nom_spec,$val_spec,$types_pages="") {
		$this->indexeur->init_index_specs();
		//		$this->parsed=false;
		$specs=$this->indexeur->get_specs_par_nom($nom_spec,$types_pages);

		// specs multiples
		$ids_specs=array();
		foreach($specs as $spec) {
			$ids_specs[]=$spec["id_type_spec"];
		}
		if(count($ids_specs)==1) {
			$str_id_spec=" = ".$ids_specs[0];
		} else if(count($ids_specs)>1) {
			$str_id_spec=" IN ( ".implode(",",$ids_specs)." )";
		}
		// specs multiples

		// ici, on ne prend le type que d'une seule, car si multiple type_spec, on est censé avoir le meme type de valeur
		$variable="valeur_".$specs[0]["type_val"];
		$this->filtres []=array("id_type_spec"=>$str_id_spec,
				"val_spec"=>is_array($val_spec)?"$variable IN ('".implode("','",$val_spec)."')":"$variable ='$val_spec'",
				"nom_spec"=>$nom_spec
		);
	}

	public function add_order($nom_spec,$sens,$calcul_spec="") {
		$this->indexeur->init_index_specs();
		$specs=$this->indexeur->get_specs_par_nom($nom_spec);

		// specs multiples
		$ids_specs=array();
		foreach($specs as $spec) {
			$ids_specs[]=$spec["id_type_spec"];
		}
		if(count($ids_specs)==1) {
			$str_id_spec=" = ".$ids_specs[0];
		} else if(count($ids_specs)>1) {
			$str_id_spec=" IN ( ".implode(",",$ids_specs)." )";
		}
		// specs multiples

		if(!empty($specs)) $variable="valeur_".$specs[0]["type_val"];
		else $variable=$nom_spec;

		$this->order []=array("id_type_spec"=>$str_id_spec,
				"variable"=>"$variable",
				"sens"=>"$sens",
				"calcul"=>$calcul_spec,
				"nom_spec"=>$nom_spec
		);
	}


	public function limite_types_specs_par_identifiants($liste_identifiants_TS) {
		if(empty($liste_identifiants_TS)){
			$this->nolimite_types_specs();
			return;
		}
		//		$liste_id_TS = mysql_fetch_column(ifReq("SELECT id_type_spec FROM ".RECH_BASE.RECH_TABLE_TYPE_SPEC." WHERE identifiant IN('".implode("','",$liste_identifiants_TS)."')"),"id_type_spec");
		if(is_array($liste_identifiants_TS)) $this->types_specs_autorisees=array_merge($this->types_specs_autorisees,$liste_identifiants_TS);
		else $this->types_specs_autorisees[]=$liste_identifiants_TS;
	}
	//	public function limite_types_specs($liste_id_TS) {
	//		if(empty($liste_id_TS)) $this->nolimite_types_specs();
	//		$this->types_specs_autorisees=$liste_id_TS;
	//	}
	public function nolimite_types_specs() {
		$this->types_specs_autorisees=array();
	}
	/**
	 *
	 * @param p : nom de la table qui contient id_page
	 * @return array("from"=> $tab_from_supp,"where"=>$tab_where_supp)
	 */
	public function to_sql($p="p") {
		$tab_from_supp="";
		$tab_where_supp="";
		$tab_order_supp=array();
		$tab_select_supp=array();
		$i=0;
		foreach($this->filtres as $un_filtre_spec) {
//			echo "in ? $un_filtre_spec[nom_spec] , ".implode(",",$this->types_specs_autorisees);
			if(empty($this->types_specs_autorisees) || in_array($un_filtre_spec["nom_spec"],$this->types_specs_autorisees)) {
				$tab_from_supp.=", ".RECH_BASE.RECH_TABLE_SPEC_VAL." sv$i";
				$tab_where_supp.=" AND sv$i.id_page=$p.id_page AND sv$i.id_type_spec ".$un_filtre_spec["id_type_spec"]." AND sv$i.".$un_filtre_spec["val_spec"];
				$i++;
			}
		}
		foreach($this->order as $un_order_spec) {
			if(empty($this->types_specs_autorisees) || in_array($un_order_spec["id_type_spec"],$this->types_specs_autorisees)) {
				if(!empty($un_order_spec["calcul"])) {
					$tab_order_supp[]=$un_order_spec["variable"]." ".$un_order_spec["sens"];
					$tab_select_supp[]=$un_order_spec["calcul"]." AS ".$un_order_spec["variable"];
				} else if($un_order_spec["variable"] == "pertinence") {
					$tab_order_supp[]="pertinence ".$un_order_spec["sens"];
				} else {
					$tab_select_supp[]="sv$i.".$un_order_spec["variable"]." AS recherche_".$un_order_spec["nom_spec"];
					$tab_from_supp.=", ".RECH_BASE.RECH_TABLE_SPEC_VAL." sv$i";
					$tab_order_supp[]="sv$i.".$un_order_spec["variable"]." ".$un_order_spec["sens"];
					$tab_where_supp.=" AND sv$i.id_page=$p.id_page AND sv$i.id_type_spec ".$un_order_spec["id_type_spec"];
				}
				$i++;
			}
		}
		$orderBy=implode(" , ",$tab_order_supp);
		$select=implode(" , ",$tab_select_supp);
		return array("from"=> $tab_from_supp,"where"=>$tab_where_supp,"order"=>$orderBy,"select"=>$select);
	}

}
?>